// ignore_for_file: must_be_immutable, non_constant_identifier_names, library_private_types_in_public_api

import 'package:flutter/material.dart';
import 'package:cool_dropdown/cool_dropdown.dart';
import 'package:cool_dropdown/models/cool_dropdown_item.dart';
import 'package:get/get.dart';
import 'package:viser_remit/core/utils/my_strings.dart';
import 'package:viser_remit/core/utils/style.dart';

import '../../../../../../core/utils/dimensions.dart';
import '../../../../../../core/utils/my_color.dart';
import '../../../../../../data/controller/home/home_controller.dart';
import '../../../../../../data/model/home/country_info_model.dart';

class SendCurrencyDropDown extends StatefulWidget {
  bool isBorder;
  Color bgColor;
  bool enableOptionalItem;

  SendCurrencyDropDown({super.key, this.isBorder = true, this.bgColor = MyColor.colorWhite, this.enableOptionalItem = false});

  @override
  _SendCurrencyDropDownState createState() => _SendCurrencyDropDownState();
}

class _SendCurrencyDropDownState extends State<SendCurrencyDropDown> {
  final CurrencyDropDawnController = DropdownController();

  @override
  Widget build(BuildContext context) {
    return GetBuilder<HomeController>(builder: (controller) {
      return Container(
        padding: const EdgeInsets.all(2),
        decoration: BoxDecoration(
          color: MyColor.transparentColor,
          border: widget.isBorder
              ? Border.all(
                  color: MyColor.customBorderColor,
                  width: .5,
                )
              : const Border(),
          borderRadius: BorderRadius.circular(12),
        ),
        child: WillPopScope(
          onWillPop: () async {
            if (CurrencyDropDawnController.isOpen) {
              CurrencyDropDawnController.close();
              return Future.value(false);
            } else {
              return Future.value(true);
            }
          },
          child: CoolDropdown(
            isMarquee: true,
            controller: CurrencyDropDawnController,
            dropdownList: controller.sendingCountryList.map((SendingCountries value) {
              return CoolDropdownItem<SendingCountries>(
                value: value,
                label: "${value.name} - ${value.currency}",
                icon: Container(margin: const EdgeInsetsDirectional.only(start: Dimensions.space5), height: 25, width: 25, child: CircleAvatar(backgroundImage: NetworkImage('${controller.imagePath}/${value.image}'))),
              );
            }).toList(),
            defaultItem: widget.enableOptionalItem
                ? CoolDropdownItem<SendingCountries>(
                    value: controller.selectedSendCountry,
                    label: "${controller.selectedSendCountry.name} - ${controller.selectedSendCountry.currency}",
                    icon: Container(margin: const EdgeInsetsDirectional.only(start: Dimensions.space5), height: 25, width: 25, child: CircleAvatar(backgroundImage: NetworkImage('${controller.imagePath}/${controller.selectedSendCountry.image}'))),
                  )
                : null,
            onChange: (value) async {
              if (CurrencyDropDawnController.isError) {
                await CurrencyDropDawnController.resetError();
              }
              CurrencyDropDawnController.close();
              controller.setSendCountry(value, value.id.toString());
            },
            onOpen: (value) {
             
            },
            resultOptions: ResultOptions(
              openBoxDecoration: BoxDecoration(
                color: widget.bgColor,
                borderRadius: BorderRadius.circular(8),
              ),
              padding: const EdgeInsets.symmetric(horizontal: 10),
              width: MediaQuery.of(context).size.width,
              icon: const SizedBox(
                width: 10,
                height: 10,
                child: CustomPaint(
                  painter: DropdownArrowPainter(),
                ),
              ),
              textOverflow: TextOverflow.ellipsis,
              render: ResultRender.all,
              alignment: Alignment.center,
              placeholderTextStyle: regularLarge.copyWith(color: MyColor.body1),
              placeholder: MyStrings.selectOne.tr,
              isMarquee: true,
              boxDecoration: const BoxDecoration(
                // color: MyColor.colorWhite,
                borderRadius: BorderRadius.zero,
              ),
            ),
            dropdownOptions: DropdownOptions(
              borderRadius: BorderRadius.zero,
              top: 10,
              height: MediaQuery.of(context).size.height / 2,
              gap: const DropdownGap.all(2),
              borderSide: const BorderSide(width: 1, color: MyColor.borderColor),
              padding: const EdgeInsets.all(10),
              align: DropdownAlign.left,
              animationType: DropdownAnimationType.scale,
            ),
            dropdownTriangleOptions: const DropdownTriangleOptions(
              width: 0,
              height: 0,
              align: DropdownTriangleAlign.center,
              borderRadius: 3,
              left: 20,
            ),
            dropdownItemOptions: DropdownItemOptions(
              boxDecoration: BoxDecoration(
                  color: MyColor.colorWhite,
                  border: Border.all(
                    color: MyColor.borderColor,
                    width: 1,
                  )),
              selectedTextStyle: regularLarge.copyWith(color: MyColor.body1),
              selectedBoxDecoration: BoxDecoration(border: Border.all(color: MyColor.borderColor, width: 1), color: MyColor.primaryColor.withOpacity(0.4)),
              isMarquee: true,
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              render: DropdownItemRender.all,
              textOverflow: TextOverflow.ellipsis,
              // textStyle: bodyText,
              height: 50,
            ),
          ),
        ),
      );
    });
  }
}
